/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.fabric.event;

import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.resource.v1.ResourceLoader;
import net.fabricmc.fabric.api.resource.v1.pack.PackActivationType;
import net.fabricmc.fabric.impl.resource.ResourceLoaderImpl;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.block.entity.BlockEntityTicker;
import noobanidus.mods.lootr.common.chunk.LoadedChunks;
import noobanidus.mods.lootr.common.command.CommandLootr;
import noobanidus.mods.lootr.fabric.event.HandleBreak;

public class LootrEventsInit {
    public static MinecraftServer serverInstance;

    public static void registerEvents() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            serverInstance = server;
            LoadedChunks.clear();
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            serverInstance = null;
            LoadedChunks.clear();
        });
        ServerTickEvents.END_SERVER_TICK.register(BlockEntityTicker::onServerTick);
        ServerChunkEvents.CHUNK_LOAD.register(LoadedChunks::onChunkLoad);
        ServerChunkEvents.CHUNK_UNLOAD.register(LoadedChunks::onChunkUnload);
        PlayerBlockBreakEvents.BEFORE.register(HandleBreak::beforeBlockBreak);
        PlayerBlockBreakEvents.CANCELED.register(HandleBreak::afterBlockBreak);
        CommandRegistrationCallback.EVENT.register((dispatcher, reg, env) -> CommandLootr.register((CommandDispatcher<class_2168>)dispatcher));
        ModContainer container = (ModContainer)FabricLoader.getInstance().getModContainer("lootr").orElseThrow();
        ResourceLoader.registerBuiltinPack((class_2960)LootrAPI.rl("old_textures"), (ModContainer)container, (class_2561)class_2561.method_43470((String)"Lootr - Old Textures"), (PackActivationType)PackActivationType.NORMAL);
        LootrEventsInit.registerPack(container, "lootr_no_advancements", (class_2561)class_2561.method_43470((String)"Disable Lootr Advancements"));
        LootrEventsInit.registerPack(container, "lootr_no_suspicious_blocks", (class_2561)class_2561.method_43470((String)"Disable Lootr Converting Suspicious Blocks"));
    }

    private static void registerPack(ModContainer container, String name, class_2561 desc) {
        ResourceLoaderImpl.registerBuiltinPack((class_2960)class_2960.method_60655((String)container.getMetadata().getId(), (String)name), (String)("datapacks/" + name), (ModContainer)container, (class_2561)desc, (PackActivationType)PackActivationType.NORMAL);
    }
}

